<?php

namespace App\Actions\Config\Module;

class StoreSubscriptionConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'invoice_number_prefix' => 'sometimes',
            'invoice_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'invoice_number_suffix' => 'sometimes',
            'tax_id_label' => 'sometimes|min:2|max:100',
            'tax_id_number' => 'sometimes|min:2|max:100',
            'company_name' => 'sometimes|min:2|max:100',
            'company_address' => 'sometimes|max:1000',
            'company_email' => 'sometimes|email|min:2|max:100',
            'company_phone' => 'sometimes|min:2|max:100',
            'invoice_terms' => 'sometimes|max:1000',
            'enable_paypal' => 'boolean',
            'enable_live_paypal_mode' => 'boolean',
            'paypal_client' => 'required_if:enable_paypal,true',
            'paypal_secret' => 'required_if:enable_paypal,true',
            'enable_stripe' => 'boolean',
            'enable_live_stripe_mode' => 'boolean',
            'stripe_client' => 'required_if:enable_stripe,true',
            'stripe_secret' => 'required_if:enable_stripe,true',
            'enable_razorpay' => 'boolean',
            'enable_live_razorpay_mode' => 'boolean',
            'razorpay_client' => 'required_if:enable_razorpay,true',
            'razorpay_secret' => 'required_if:enable_razorpay,true',
            'enable_paystack' => 'boolean',
            'enable_live_paystack_mode' => 'boolean',
            'paystack_client' => 'required_if:enable_paystack,true',
            'paystack_secret' => 'required_if:enable_paystack,true',
        ], [
            'paypal_client.required_if' => __('validation.required'),
            'paypal_secret.required_if' => __('validation.required'),
            'stripe_client.required_if' => __('validation.required'),
            'stripe_secret.required_if' => __('validation.required'),
            'razorpay_client.required_if' => __('validation.required'),
            'razorpay_secret.required_if' => __('validation.required'),
            'paystack_client.required_if' => __('validation.required'),
            'paystack_secret.required_if' => __('validation.required'),
        ], [
            'invoice_number_prefix' => __('subscription.config.props.invoice_number_prefix'),
            'invoice_number_digit' => __('subscription.config.props.invoice_number_digit'),
            'invoice_number_suffix' => __('subscription.config.props.invoice_number_suffix'),
            'tax_id_label' => __('subscription.config.props.tax_id_label'),
            'tax_id_number' => __('subscription.config.props.tax_id_number'),
            'company_name' => __('subscription.config.props.company_name'),
            'company_address' => __('subscription.config.props.company_address'),
            'company_email' => __('subscription.config.props.company_email'),
            'company_phone' => __('subscription.config.props.company_phone'),
            'invoice_terms' => __('subscription.config.props.invoice_terms'),
            'enable_paypal' => __('subscription.config.props.enable_payment_gateway', ['attribute' => 'PayPal']),
            'enable_live_paypal_mode' => __('subscription.config.props.payment_gateway_mode', ['attribute' => 'PayPal']),
            'paypal_client' => __('subscription.config.props.payment_gateway_client', ['attribute' => 'PayPal']),
            'paypal_secret' => __('subscription.config.props.payment_gateway_secret', ['attribute' => 'PayPal']),
            'enable_stripe' => __('subscription.config.props.enable_payment_gateway', ['attribute' => 'Stripe']),
            'enable_live_stripe_mode' => __('subscription.config.props.payment_gateway_mode', ['attribute' => 'Stripe']),
            'stripe_client' => __('subscription.config.props.payment_gateway_client', ['attribute' => 'Stripe']),
            'stripe_secret' => __('subscription.config.props.payment_gateway_secret', ['attribute' => 'Stripe']),
            'enable_razorpay' => __('subscription.config.props.enable_payment_gateway', ['attribute' => 'Razorpay']),
            'enable_live_razorpay_mode' => __('subscription.config.props.payment_gateway_mode', ['attribute' => 'Razorpay']),
            'razorpay_client' => __('subscription.config.props.payment_gateway_client', ['attribute' => 'Razorpay']),
            'razorpay_secret' => __('subscription.config.props.payment_gateway_secret', ['attribute' => 'Razorpay']),
            'enable_paystack' => __('subscription.config.props.enable_payment_gateway', ['attribute' => 'Paystack']),
            'enable_live_paystack_mode' => __('subscription.config.props.payment_gateway_mode', ['attribute' => 'Paystack']),
            'paystack_client' => __('subscription.config.props.payment_gateway_client', ['attribute' => 'Paystack']),
            'paystack_secret' => __('subscription.config.props.payment_gateway_secret', ['attribute' => 'Paystack']),
        ]);

        return $input;
    }
}
