<?php

namespace App\Actions\Config\Module;

class StorePayrollConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'code_number_prefix' => 'sometimes|max:100',
            'code_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'code_number_suffix' => 'sometimes|max:100',
            'enable_payhead_round_off' => 'sometimes|boolean',
            'show_payroll_as_total_component' => 'sometimes|boolean',
        ], [
            'code_number_prefix' => __('payroll.config.props.number_prefix'),
            'code_number_digit' => __('payroll.config.props.number_digit'),
            'code_number_suffix' => __('payroll.config.props.number_suffix'),
            'enable_payhead_round_off' => __('payroll.config.props.payhead_round_off'),
            'show_payroll_as_total_component' => __('payroll.config.props.show_payroll_as_total_component'),
        ], []);

        return $input;
    }
}
