<?php

namespace App\Actions\Config;

class StoreFeatureConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'enable_todo' => 'sometimes|boolean',
            'enable_activity_log' => 'sometimes|boolean',
            'enable_post' => 'sometimes|boolean',
            'enable_job_application' => 'sometimes|boolean',
            'job_application_instruction' => 'sometimes|max:2000',
        ], [], [
            'enable_todo' => __('config.feature.props.todo'),
            'enable_activity_log' => __('config.feature.props.activity_log'),
            'enable_post' => __('config.feature.props.post'),
            'enable_job_application' => __('config.feature.props.job_application'),
            'job_application_instruction' => __('config.feature.props.job_application_instruction'),
        ]);

        return $input;
    }
}
