<?php

namespace App\Actions\Saas;

use App\Enums\Saas\TenantStatus;
use App\Models\Saas\Tenant;
use Closure;
use Illuminate\Http\Request;

class CompleteInstallation
{
    public function handle(Request $request, Closure $next)
    {
        (new SwitchDatabase)->execute();

        $tenant = Tenant::find($request->tenant_id);

        $expiryDate = today()->toDateString();
        if ($tenant->is_trial) {
            $expiryDate = $tenant->getMeta('trial_ends_at') ?? today()->toDateString();
        } else {
            $expiryDate = today()->subDays(1)->toDateString();
        }

        $tenant->database = $request->database;
        $tenant->status = TenantStatus::RUNNING->value;
        $tenant->expiry_date = $expiryDate;
        $meta = $tenant->meta;
        $tenant->meta = $meta;
        $tenant->save();

        return $next($request);
    }
}
