<?php

namespace App\Actions\Saas;

class GetPaymentGateway
{
    public function execute(): array
    {
        $paymentGateways = [];
        if (config('saas.landlord.subscription.enable_razorpay')) {
            $paymentGateways[] = [
                'value' => 'razorpay',
                'label' => 'Razorpay',
            ];
        }

        if (config('saas.landlord.subscription.enable_paystack')) {
            $paymentGateways[] = [
                'value' => 'paystack',
                'label' => 'Paystack',
            ];
        }

        if (config('saas.landlord.subscription.enable_stripe')) {
            $paymentGateways[] = [
                'value' => 'stripe',
                'label' => 'Stripe',
                'key' => config('saas.landlord.subscription.stripe_client'),
            ];
        }

        if (config('saas.landlord.subscription.enable_paypal')) {
            $paymentGateways[] = [
                'value' => 'paypal',
                'label' => 'Paypal',
                'key' => config('saas.landlord.subscription.paypal_client'),
            ];
        }

        return $paymentGateways;
    }
}
