<?php

namespace App\Actions\Saas;

use App\Helpers\SysHelper;
use Closure;
use Illuminate\Http\Request;

class MigrateAndSeedDatabase
{
    public function handle(Request $request, Closure $next)
    {
        \Artisan::call('migrate', ['--force' => true]);
        \Artisan::call('db:seed', ['--force' => true, '--class' => 'TeamSeeder']);
        \Artisan::call('db:seed', ['--force' => true, '--class' => 'RoleSeeder']);
        \Artisan::call('db:seed', ['--force' => true, '--class' => 'PermissionSeeder']);
        \Artisan::call('db:seed', ['--force' => true, '--class' => 'AssignPermissionSeeder']);
        \Artisan::call('db:seed', ['--force' => true, '--class' => 'TemplateSeeder']);

        SysHelper::setTeam(1);

        return $next($request);
    }
}
