<?php

namespace App\Actions\Saas;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SeedUser
{
    public function handle(Request $request, Closure $next)
    {
        $user = User::forceCreate([
            'uuid' => (string) Str::uuid(),
            'name' => $request->name,
            'email' => $request->email,
            'username' => $request->username,
            'password' => bcrypt($request->password),
            'status' => 'activated',
            'email_verified_at' => now(),
        ]);

        $user->meta = ['is_default' => true];
        $user->save();

        $user->assignRole('admin');

        return $next($request);
    }
}
