<?php

namespace App\Actions\Saas;

use App\Models\Contact;
use App\Models\Employee\Employee;
use Closure;
use Illuminate\Http\Request;

class Setup
{
    public function handle(Request $request, Closure $next)
    {
        $contact = Contact::forceCreate([
            'first_name' => $request->name,
            'email' => $request->email,
            'team_id' => 1,
            'user_id' => 1,
        ]);

        $employee = Employee::forceCreate([
            'contact_id' => $contact->id,
            'code_number' => 'SA1',
            'joining_date' => today()->toDateString(),
            'meta' => ['is_default' => true],
        ]);

        return $next($request);
    }
}
