<?php

namespace App\Actions\Saas\Subscription;

use App\Enums\Saas\SubscriptionType;
use App\Models\Saas\Tenant;

class CalculateFreeSubscription
{
    public function execute(Tenant $tenant)
    {
        $action = SubscriptionType::FREE->value;

        $startDate = $tenant->expiry_date->value ?: today()->toDateString();

        $endDate = null;

        $total = 0;

        return compact('action', 'startDate', 'endDate', 'total');
    }
}
