<?php

namespace App\Actions\Saas\Subscription;

use App\Enums\Saas\PlanFrequency;
use App\Enums\Saas\SubscriptionType;
use App\Models\Saas\Plan;
use App\Models\Saas\Tenant;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class CalculateNewSubscription
{
    public function execute(Request $request, Tenant $tenant, Plan $newPlan, Collection $existingSubscriptions)
    {
        $action = SubscriptionType::NEW->value;

        $currency = $request->currency;
        $frequency = $request->frequency;

        $activationCharge = $newPlan->getActivationCharge($currency);

        $amount = $newPlan->getPrice($currency, $frequency);

        $startDate = today()->toDateString();

        if ($tenant->is_trial) {
            $startDate = config('saas.landlord.tenant.trial_ends_on_subscription', true) ? today()->toDateString() : ($tenant->getMeta('trial_ends_at') ?? today()->toDateString());
        }

        $endDate = Carbon::parse($startDate)->addMonths(PlanFrequency::getMonth($frequency))->toDateString();

        $taxableAmount = $activationCharge + $amount;

        $tax = (new GetTax)->execute(plan: $newPlan, amount: $taxableAmount);
        $taxAmount = Arr::get($tax, 'taxAmount', 0);
        $taxAddition = Arr::get($tax, 'taxAddition', 0);
        $taxLabel = Arr::get($tax, 'taxLabel');

        $total = $activationCharge + $amount + $taxAddition;

        return compact('action', 'activationCharge', 'amount', 'startDate', 'endDate', 'taxAmount', 'taxLabel', 'total');
    }
}
