<?php

namespace App\Actions\Saas\Subscription;

use App\Enums\Saas\SubscriptionType;
use App\Models\Saas\Plan;
use App\Models\Saas\Tenant;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;

class CalculateSiblingSubscription
{
    public function execute(Request $request, Tenant $tenant, Plan $newPlan, Collection $existingSubscriptions)
    {
        $action = SubscriptionType::SIBLING->value;

        $startDate = today()->toDateString();

        $endDate = $tenant->expiry_date->value;

        $total = 0;

        return compact('action', 'startDate', 'endDate', 'total');
    }
}
