<?php

namespace App\Actions\Saas\Subscription;

use App\Models\Saas\Subscription;
use App\Support\FormatCodeNumber;
use Closure;
use Illuminate\Support\Arr;

class CompleteSubscription
{
    use FormatCodeNumber;

    public function handle(Subscription $subscription, Closure $next)
    {
        if ($subscription->amount->value > 0) {
            $codeNumberDetail = $this->codeNumber();

            $subscription->number_format = Arr::get($codeNumberDetail, 'number_format');
            $subscription->number = Arr::get($codeNumberDetail, 'number');
            $subscription->code_number = Arr::get($codeNumberDetail, 'code_number');
        }

        $subscription->status = 1;
        $subscription->save();

        return $next($subscription);
    }

    private function codeNumber()
    {
        $numberPrefix = config('saas.landlord.subscription.invoice_number_prefix');
        $numberSuffix = config('saas.landlord.subscription.invoice_number_suffix');
        $digit = config('saas.landlord.subscription.invoice_number_digit', 0);

        $numberFormat = $numberPrefix.'%NUMBER%'.$numberSuffix;

        $numberFormat = $this->preFormatForDate($numberFormat);

        $codeNumber = (int) Subscription::query()
            ->whereStatus(1)
            ->whereNumberFormat($numberFormat)
            ->max('number');

        $codeNumber += 1;

        return $this->getCodeNumber(number: $codeNumber, digit: $digit, format: $numberFormat);
    }
}
