<?php

namespace App\Actions\Saas\Subscription;

use App\Models\Saas\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;

class CreateSubscription
{
    public function execute(Request $request, array $params = []): Subscription
    {
        $subscription = Subscription::forceCreate([
            'uuid' => (string) Str::uuid(),
            'action' => Arr::get($params, 'action'),
            'tenant_id' => config('saas.tenant.id'),
            'plan_id' => $request->plan->id,
            'start_date' => Arr::get($params, 'startDate'),
            'expiry_date' => Arr::get($params, 'endDate'),
            'amount' => Arr::get($params, 'total', 0),
            'currency' => $request->currency,
            'frequency' => $request->frequency,
            'billing_address' => [
                'name' => $request->name,
                'email' => $request->email,
                'address' => $request->address,
            ],
            'tax_details' => [
                'amount' => Arr::get($params, 'taxAmount', 0),
                'rate' => Arr::get($request->plan->tax, 'rate', 0),
                'label' => Arr::get($request->plan->tax, 'label'),
                'is_exclusive' => (bool) Arr::get($request->plan->tax, 'is_exclusive'),
            ],
            'meta' => [
                'is_online' => true,
                'company' => [
                    'tax_id_label' => config('saas.landlord.subscription.tax_id_label'),
                    'tax_id_number' => config('saas.landlord.subscription.tax_id_number'),
                    'name' => config('saas.landlord.subscription.company_name'),
                    'address' => config('saas.landlord.subscription.company_address'),
                    'email' => config('saas.landlord.subscription.company_email'),
                    'phone' => config('saas.landlord.subscription.company_phone'),
                    'tnc' => config('saas.landlord.subscription.invoice_terms'),
                ],
                'reference_number' => Str::random(16),
                'activation_charge' => Arr::get($params, 'activationCharge', 0),
            ],
        ]);

        return $subscription;
    }
}
