<?php

namespace App\Concerns\Saas;

use App\Helpers\Saas\TenantHelper;
use App\Models\Employee\Employee;
use App\Models\Team;
use Illuminate\Validation\ValidationException;

trait CheckLimit
{
    public static function bootCheckLimit()
    {
        //
    }

    public function checkTeamLimit(int $count = 1): void
    {
        if (app()->runningInConsole()) {
            return;
        }

        $maxTeamLimit = TenantHelper::getPlanFeature('max_team_limit');

        $teamCount = Team::count() + $count;

        if ($teamCount > $maxTeamLimit) {
            throw ValidationException::withMessages(['message' => trans('saas.errors.max_team_limit_crossed', ['attribute' => $maxTeamLimit])]);
        }
    }

    public function checkEmployeeLimit(int $count = 1): void
    {
        if (app()->runningInConsole()) {
            return;
        }

        $teamWiseLimit = TenantHelper::getPlanFeature('team_wise_limit');

        if ($teamWiseLimit) {
            $maxLimit = TenantHelper::getPlanFeature('max_employee_per_team_limit');

            $employeeCount = Employee::whereHas('contact', function ($q) {
                $q->whereTeamId(session('team_id'));
            })->count();
        } else {
            $maxLimit = TenantHelper::getPlanFeature('max_employee_limit');

            $employeeCount = Employee::count();
        }

        $employeeCount += $count;

        if ($employeeCount > $maxLimit) {
            throw ValidationException::withMessages(['message' => trans('saas.errors.max_employee_limit_crossed', ['attribute' => $maxLimit])]);
        }
    }
}
