<?php

namespace App\Console\Commands;

use App\Actions\Saas\SwitchDatabase;
use App\Concerns\GetTenantsForCommand;
use App\Models\Config\Template;
use Illuminate\Console\Command;
use Illuminate\Support\Arr;

class SyncTemplate extends Command
{
    use GetTenantsForCommand;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:template {tenant?* : ID of Tenants} {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync template';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $force = $this->option('force');

        if (\App::environment('production') && ! $force) {
            $this->error('Could not sync in production mode');
            exit;
        }

        $tenantIds = $this->argument('tenant');

        $tenants = $this->getTenants($tenantIds);

        $bar = $this->output->createProgressBar(count($tenants));
        $bar->start();

        activity()->disableLogging();

        foreach ($tenants as $tenant) {
            $this->newLine();
            $this->info('Sync Permission tenant: '.$tenant->id);

            (new SwitchDatabase)->execute($tenant->database);

            $allTemplates = Arr::getVar('templates');

            foreach ($allTemplates as $key => $templates) {
                foreach ($templates as $template) {
                    $newTemplate = Template::firstOrCreate([
                        'type' => $key,
                        'code' => Arr::get($template, 'code'),
                    ]);

                    $newTemplate->update([
                        'name' => Arr::get($template, 'name'),
                        'subject' => Arr::get($template, 'subject'),
                        'content' => Arr::get($template, 'content'),
                    ]);
                }
            }

            $this->info('Template synced.');

            $bar->advance();
            $this->newLine();

            (new SwitchDatabase)->execute();
        }

        $bar->finish();

        activity()->enableLogging();

        $this->info('Templates synced.');
    }
}
