<?php

namespace App\Contracts\Saas;

use App\Models\Saas\Subscription;
use Illuminate\Http\Request;

interface PaymentGateway
{
    public function getName(): string;

    public function isEnabled(): void;

    public function getMultiplier(Request $request): float;

    public function supportedCurrencies(): array;

    public function unsupportedCurrencies(): array;

    public function initiatePayment(Request $request, Subscription $subscription): array;

    public function confirmPayment(Request $request): Subscription;

    public function failPayment(Request $request): Subscription;
}
