<?php

namespace App\Http\Controllers\Leave;

use App\Http\Controllers\Controller;
use App\Http\Requests\Leave\RequestStatusRequest as LeaveRequestStatusRequest;
use App\Models\Leave\Request as LeaveRequest;
use App\Services\Leave\RequestActionService as LeaveRequestActionService;
use Illuminate\Http\Request;

class RequestActionController extends Controller
{
    public function undoStatus(Request $request, string $leaveRequest, LeaveRequestActionService $service)
    {
        $leaveRequest = LeaveRequest::findByUuidOrFail($leaveRequest);

        $this->authorize('action', $leaveRequest);

        $service->undoStatus($request, $leaveRequest);

        return response()->success([
            'message' => trans('global.updated', ['attribute' => trans('leave.request.props.status')]),
        ]);
    }

    public function updateStatus(LeaveRequestStatusRequest $request, string $leaveRequest, LeaveRequestActionService $service)
    {
        $leaveRequest = $request->leave_request;

        $this->authorize('action', $leaveRequest);

        $service->updateStatus($request, $leaveRequest);

        return response()->success([
            'message' => trans('global.updated', ['attribute' => trans('leave.request.props.status')]),
        ]);
    }
}
