<?php

namespace App\Http\Controllers\Payroll;

use App\Http\Controllers\Controller;
use App\Models\Payroll\SalaryTemplate;
use App\Services\Payroll\SalaryTemplateActionService;
use Illuminate\Http\Request;

class SalaryTemplateActionController extends Controller
{
    public function __construct()
    {
        $this->middleware('role:admin')->only('forceUpdate');
    }

    public function forceUpdate(Request $request, string $uuid, SalaryTemplateActionService $service)
    {
        $salaryTemplate = SalaryTemplate::findByUuidOrFail($uuid);

        $service->forceUpdate($request, $salaryTemplate);

        return response()->json([
            'message' => __('global.updated', [
                'attribute' => trans('payroll.salary_template.salary_template'),
            ]),
        ]);
    }
}
