<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Validation\ValidationException;

class ModuleAvailable
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next, $feature)
    {
        if (! in_array($feature, config('saas.available_modules', []))) {
            throw ValidationException::withMessages(['message' => __('general.errors.feature_not_available')]);
        }

        return $next($request);
    }
}
