<?php

namespace App\Http\Requests\Saas;

use App\Concerns\SimpleValidation;
use App\Enums\Saas\PlanFrequency;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Enum;

class SubscriptionRequest extends FormRequest
{
    use SimpleValidation;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'plan' => 'required|uuid',
            'frequency' => ['required', new Enum(PlanFrequency::class)],
            'currency' => 'required|in:'.config('saas.landlord.system.currencies'),
        ];

        if ($this->route()->getName() == 'subscriptions.calculate') {
            return $rules;
        }

        $rules['name'] = 'required|min:2|max:100';
        $rules['email'] = 'required|email|max:100';
        $rules['address.address_line1'] = 'required|min:2|max:100';
        $rules['address.address_line2'] = 'nullable|min:2|max:100';
        $rules['address.city'] = 'required|min:2|max:100';
        $rules['address.state'] = 'required|min:2|max:100';
        $rules['address.zipcode'] = 'required|min:2|max:100';
        $rules['address.country'] = 'required|min:2|max:100';

        return $rules;
    }

    public function withValidator($validator)
    {
        if (! $validator->passes()) {
            $validator->after(function ($validator) {
                $this->change($validator, 'address.address_line1', 'address_address_line1');
                $this->change($validator, 'address.address_line2', 'address_address_line2');
                $this->change($validator, 'address.city', 'address_city');
                $this->change($validator, 'address.state', 'address_state');
                $this->change($validator, 'address.zipcode', 'address_zipcode');
                $this->change($validator, 'address.country', 'address_country');
            });

            return;
        }

        $validator->after(function ($validator) {
            //
        });
    }

    /**
     * Translate fields with user friendly name.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'plan' => __('saas.plan.plan'),
            'frequency' => __('saas.plan.props.frequency'),
            'currency' => __('config.system.props.currency'),
            'name' => __('saas.subscription.props.name'),
            'email' => __('saas.subscription.props.email'),
            'address.address_line1' => __('contact.props.address.address_line1'),
            'address.address_line2' => __('contact.props.address.address_line2'),
            'address.city' => __('contact.props.address.city'),
            'address.state' => __('contact.props.address.state'),
            'address.zipcode' => __('contact.props.address.zipcode'),
            'address.country' => __('contact.props.address.country'),
        ];
    }
}
