<?php

namespace App\Models\Saas;

use App\Concerns\HasMeta;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;

class Plan extends Model
{
    use HasFactory, HasMeta;

    protected $table = 'plans';

    protected $casts = [
        'meta' => 'array',
        'features' => 'array',
        'tax' => 'array',
        'pricing' => 'array',
    ];

    protected $connection = 'landlord';

    public function getFeature(string $option)
    {
        return Arr::get($this->features, $option);
    }

    public function getActivationCharge(string $currency): float
    {
        if (! $this->getFeature('has_activation_charge')) {
            return 0;
        }

        return Arr::get($this->pricing, 'activation_charge.'.$currency, 0);
    }

    public function getPrice(string $currency, string $frequency): float
    {
        if ($this->getFeature('is_free')) {
            return 0;
        }

        return Arr::get($this->pricing, 'price.'.$frequency.'.'.$currency, 0);
    }
}
