<?php

namespace App\Providers;

use App\Concerns\ModelRelation;
use App\Contracts\Saas\PaymentGateway;
use App\Services\Saas\PaymentGateway\Paypal;
use App\Services\Saas\PaymentGateway\Paystack;
use App\Services\Saas\PaymentGateway\Razorpay;
use App\Services\Saas\PaymentGateway\Stripe;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;
use Spatie\Activitylog\Models\Activity;

class AppServiceProvider extends ServiceProvider
{
    use ModelRelation;

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(PaymentGateway::class, function ($app) {
            if (request('gateway') === 'razorpay') {
                return $app->make(Razorpay::class);
            } elseif (request('gateway') === 'paystack') {
                return $app->make(Paystack::class);
            } elseif (request('gateway') === 'stripe') {
                return $app->make(Stripe::class);
            } elseif (request('gateway') === 'paypal') {
                return $app->make(Paypal::class);
            }
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Activity::saving(function (Activity $activity) {
            $activity->properties = $activity->properties->put('ip', \Request::ip());
            $activity->properties = $activity->properties->put('user_agent', \Request::header('User-Agent'));

            if (session()->has('impersonate')) {
                $activity->properties = $activity->properties->put('impersonate', session('impersonate'));
            }
        });

        if (config('database.type') == 'mariadb') {
            Schema::defaultStringLength(191);
        }

        if (app()->environment('local')) {
            Mail::alwaysTo('hello@scriptmint.com');
        }

        JsonResource::withoutWrapping();
        Validator::includeUnvalidatedArrayKeys();

        Relation::morphMap($this->relations());
    }
}
