<?php

namespace App\Providers;

use App\Models\Employee\Employee;
use App\Models\Task\Checklist;
use App\Models\Team;
use App\Models\User;
use App\Observers\Employee\EmployeeObserver;
use App\Observers\Task\ChecklistObserver;
use App\Observers\TeamObserver;
use App\Observers\UserObserver;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        \SocialiteProviders\Manager\SocialiteWasCalled::class => [
            // ... other providers
            \SocialiteProviders\Microsoft\MicrosoftExtendSocialite::class.'@handle',
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        Team::observe(TeamObserver::class);
        User::observe(UserObserver::class);
        Employee::observe(EmployeeObserver::class);
        Checklist::observe(ChecklistObserver::class);
    }
}
