<?php

namespace App\Services\Communication;

use App\Enums\Employee\AudienceType as EmployeeAudienceType;
use App\Models\Communication\Communication;
use App\Support\HasAudience;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class SMSService
{
    use HasAudience;

    public function preRequisite(Request $request): array
    {
        $employeeAudienceTypes = EmployeeAudienceType::getOptions();

        return compact('employeeAudienceTypes');
    }

    public function create(Request $request): Communication
    {
        throw ValidationException::withMessages(['message' => trans('general.errors.feature_under_development')]);
        \DB::beginTransaction();

        $communication = Communication::forceCreate($this->formatParams($request));

        $this->storeAudience($communication, $request->all());

        \DB::commit();

        return $communication;
    }

    private function getReceipients(Request $request): array
    {
        return [];
        // $contacts = $this->getContacts($request->all());

        // $smsList = $contacts->pluck('sms')->toArray();

        // $inclusion = $request->inclusion ?? [];
        // $exclusion = $request->exclusion ?? [];

        // foreach ($inclusion as $include) {
        //     $smsList[] = $include;
        // }

        // $smsList = array_diff($smsList, $exclusion);

        // $validatedSMS = [];
        // foreach ($smsList as $sms) {
        //     if (filter_var($sms, FILTER_VALIDATE_EMAIL)) {
        //         $validatedSMS[] = $sms;
        //     }
        // }

        // return $validatedSMS;
    }

    private function formatParams(Request $request, ?Communication $communication = null): array
    {
        $receipients = $this->getReceipients($request);

        if (! count($receipients)) {
            throw ValidationException::withMessages(['recipients' => trans('communication.sms.no_recipient_found')]);
        }

        $formatted = [
            'subject' => $request->subject,
            'lists' => [
                'inclusion' => $request->inclusion,
                'exclusion' => $request->exclusion,
            ],
            'audience' => [
                'employee_type' => $request->employee_audience_type,
            ],
            'recipients' => $receipients,
            'content' => clean($request->content),
        ];

        if (! $communication) {
            $formatted['type'] = 'sms';
            $formatted['user_id'] = auth()->id();
            $formatted['team_id'] = auth()->user()->current_team_id;
        }

        return $formatted;
    }

    public function deletable(Communication $announcement): void
    {
        //
    }
}
