<?php

namespace App\Services\Saas;

use App\Contracts\ListGenerator;
use App\Http\Resources\Saas\SubscriptionResource;
use App\Models\Saas\Subscription;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class SubscriptionListService extends ListGenerator
{
    protected $allowedSorts = ['created_at'];

    protected $defaultSort = 'created_at';

    protected $defaultOrder = 'desc';

    public function getHeaders(): array
    {
        $headers = [
            [
                'key' => 'codeNumber',
                'label' => trans('saas.subscription.props.code_number'),
                'sortable' => false,
                'visibility' => true,
            ],
            [
                'key' => 'plan',
                'label' => trans('saas.plan.plan'),
                'print_label' => 'plan.name',
                'sortable' => false,
                'visibility' => true,
            ],
            [
                'key' => 'startDate',
                'label' => trans('saas.subscription.props.start_date'),
                'print_label' => 'start_date_display',
                'sortable' => false,
                'visibility' => true,
            ],
            [
                'key' => 'expiryDate',
                'label' => trans('saas.subscription.props.expiry_date'),
                'print_label' => 'expiry_date_display',
                'sortable' => false,
                'visibility' => true,
            ],
            [
                'key' => 'amount',
                'label' => trans('saas.subscription.props.amount'),
                'print_label' => 'amount_display',
                'sortable' => false,
                'visibility' => true,
            ],
            [
                'key' => 'createdAt',
                'label' => trans('general.created_at'),
                'sortable' => true,
                'visibility' => true,
            ],
        ];

        if (request()->ajax()) {
            $headers[] = $this->actionHeader;
        }

        return $headers;
    }

    public function filter(Request $request): Builder
    {
        return Subscription::query()
            ->with('plan')
            ->whereTenantId(config('saas.tenant.id'))
            ->whereStatus(1)
            ->filter([
                'App\QueryFilters\UuidMatch',
            ]);
    }

    public function paginate(Request $request): AnonymousResourceCollection
    {
        return SubscriptionResource::collection($this->filter($request)
            ->orderBy($this->getSort(), $this->getOrder())
            ->paginate((int) $this->getPageLength(), ['*'], 'current_page'))
            ->additional([
                'headers' => $this->getHeaders(),
                'meta' => [
                    'allowed_sorts' => $this->allowedSorts,
                    'default_sort' => $this->defaultSort,
                    'default_order' => $this->defaultOrder,
                ],
            ]);
    }

    public function list(Request $request): AnonymousResourceCollection
    {
        return $this->paginate($request);
    }
}
