<?php

return [
    'employee' => 'Employee',
    'employees' => 'Employees',
    'signature' => 'Signature',
    'module_title' => 'Manage all employees',
    'module_quote' => 'Take care of your Employees & they will take care of your Business.',
    'module_description' => 'Employees are your asset. You can manage all your employee records here.',
    'exists' => 'Duplicate employee details found.',
    'permission_denied' => 'You don\'t have permission to access this employee records.',
    'no_employee_associated' => 'No employee record associated with this user.',
    'joining_date_less_than_leaving_date' => 'Employee joining date cannot be less than :attribute.',
    'email_required_to_create_account' => 'Email is required to create account.',
    'audience_types' => [
        'all' => 'All Employee',
        'department_wise' => 'Department Wise Employee',
        'designation_wise' => 'Designation Wise Employee',
        'branch_wise' => 'Branch Wise Employee',
    ],
    'status' => 'Status',
    'statuses' => [
        'active' => 'Active',
        'inactive' => 'Inactive',
    ],
    'config' => [
        'config' => 'Config',
        'props' => [
            'enable_middle_name_field' => 'Enable Middle Name Field',
            'enable_third_name_field' => 'Enable Third Name Field',
            'number_prefix' => 'Code Number Prefix',
            'number_suffix' => 'Code Number Suffix',
            'number_digit' => 'Code Number Digit',
            'unique_id_number1_enabled' => 'Unique ID 1 Enabled',
            'unique_id_number2_enabled' => 'Unique ID 2 Enabled',
            'unique_id_number3_enabled' => 'Unique ID 3 Enabled',
            'unique_id_number4_enabled' => 'Unique ID 4 Enabled',
            'unique_id_number5_enabled' => 'Unique ID 5 Enabled',
            'unique_id_number1_label' => 'Unique ID 1 Label',
            'unique_id_number2_label' => 'Unique ID 2 Label',
            'unique_id_number3_label' => 'Unique ID 3 Label',
            'unique_id_number4_label' => 'Unique ID 4 Label',
            'unique_id_number5_label' => 'Unique ID 5 Label',
            'unique_id_number1_required' => 'Unique ID 1 Required',
            'unique_id_number2_required' => 'Unique ID 2 Required',
            'unique_id_number3_required' => 'Unique ID 3 Required',
            'unique_id_number4_required' => 'Unique ID 4 Required',
            'unique_id_number5_required' => 'Unique ID 5 Required',
            'allow_employee_to_submit_contact_edit_request' => 'Allow employee to submit contact edit request',
        ],
    ],
    'props' => [
        'name' => 'Employee Name',
        'code_number' => 'Employee Code',
        'joining_date' => 'Date of Joining',
        'leaving_date' => 'Date of Leaving',
    ],
    'employment_status' => [
        'employment_status' => 'Employment Status',
        'module_title' => 'Manage all Employment Status',
        'module_description' => 'Employment Status is a relationship between your company & your employee.',
        'module_example' => 'Permanent, Probation, Contract are some examples of Employment Status.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'employment_type' => [
        'employment_type' => 'Employment Type',
        'module_title' => 'Manage all Employment Types',
        'module_description' => 'Employment Types are the nature of employment your company offers to your employees.',
        'module_example' => 'Full Time, Part Time, Interns are some examples of Employment Types.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'qualification_level' => [
        'qualification_level' => 'Qualification Level',
        'module_title' => 'Manage all Qualification Levels',
        'module_description' => 'Qualification levels are the standards of different programs the institutes can offer.',
        'module_example' => 'Graduate, Post Graduate, Doctorate are some examples of Qualification Levels.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'work_shift' => [
        'work_shift' => 'Work Shift',
        'module_title' => 'Assign Work Shift',
        'module_description' => 'Work Shifts are the time slots your company has for its employees.',
    ],
    'qualification' => [
        'qualification' => 'Qualification',
        'module_title' => 'Manage all Employee Qualification Records',
        'module_description' => 'Keep the documents related to your employee\'s qualification.',
        'props' => [
            'course' => 'Course',
            'institute' => 'Institute',
            'type' => 'Type',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'affiliated_to' => 'Affiliated To',
            'result' => 'Result',
        ],
    ],
    'document_type' => [
        'document_type' => 'Document Type',
        'module_title' => 'Manage all Document Types',
        'module_description' => 'Document Types are the different categories of documents your company wish to store for the employees.',
        'module_example' => 'Resume, Salary Certificate, Experience Certificates are some examples of Document Types.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'document' => [
        'document' => 'Document',
        'module_title' => 'Manage all Employee Documents',
        'module_description' => 'Categorize the documents related to your employees.',
        'expired' => 'Expired',
        'expiring_in_days' => 'Expiring in :attribute day(s)',
        'props' => [
            'title' => 'Title',
            'start_date' => 'Validity Start',
            'end_date' => 'Validity End',
            'description' => 'Description',
        ],
    ],
    'experience' => [
        'experience' => 'Experience',
        'module_title' => 'Manage all Employee Experience Records',
        'module_description' => 'Keep records of your employee\'s previous experience.',
        'props' => [
            'headline' => 'Headline',
            'title' => 'Title',
            'location' => 'Location',
            'organization_name' => 'Organization Name',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'job_profile' => 'Job Profile',
        ],
    ],
    'record' => [
        'record' => 'Employment',
        'module_title' => 'Manage all Employment Records',
        'module_description' => 'Keep records of promotion, transfer of your employees.',
        'start_date_is_same_as_previous_start_date' => 'Employment start date must be different from previous start date.',
        'end_date_lt_start_date' => 'End date must be greater than start date.',
        'start_date_lt_previous_start_date' => 'Employment start date must be greater than previous start date.',
        'could_not_perform_if_no_change' => 'Could not perform this operation as there is no change in employment record.',
        'could_not_perform_if_employment_ended' => 'Could not perform this operation as employment has already ended.',
        'props' => [
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'period' => 'Period',
            'duration' => 'Duration',
            'remarks' => 'Remarks',
            'end' => 'End Employment',
        ],
    ],
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'module_title' => 'Manage all Account Records',
        'module_description' => 'Keep all account related information of your employees.',
    ],
    'edit_info' => 'If you want to edit any information, you can submit a request here.',
    'upload_document_info' => 'You can also upload document for proof of your edit request.',
    'edit_request' => [
        'edit_request' => 'Edit Request',
        'module_title' => 'List all Edit Requests',
        'module_description' => 'Manage all Edit Requests for Employee Information',
        'edit_info' => 'If you want to edit any information, you can submit a request here.',
        'upload_document_info' => 'You can also upload document for proof of your edit request.',
        'submitted' => 'Your request for edit information is submitted and applied after approval.',
        'already_pending' => 'You have already submitted a request for edit information.',
        'request_by' => 'Request By',
        'request_by_name' => 'Request By :attribute',
        'already_processed' => 'This request is already processed.',
        'statuses' => [
            'approve' => 'Approve',
            'reject' => 'Reject',
        ],
        'props' => [
            'action' => 'Action',
            'comment' => 'Comment',
            'status' => 'Status',
        ],
    ],
];
