<?php

return [
    'finance' => 'Finance',
    'unsupported_currency' => 'Sorry! Your payment could not be processed because of unsupported currency.',
    'payment_statuses' => [
        'not_applicable' => 'Not Applicable',
        'paid' => 'Paid',
        'unpaid' => 'Unpaid',
        'partial' => 'Partial',
        'partially_paid' => 'Partially Paid',
    ],
    'ledger' => [
        'ledger' => 'Ledger',
        'ledgers' => 'Ledgers',
        'module_title' => 'Manage all Ledgers',
        'module_description' => 'A ledger is a book or collection of accounts in which account transactions are recorded.',
        'primary_ledger' => 'Primary Ledger',
        'secondary_ledger' => 'Secondary Ledger',
        'groups' => [
            'cash' => 'Cash',
            'bank_account' => 'Bank Account',
            'overdraft_account' => 'Overdraft Account',
            'sundry_debtor' => 'Sundry Debtor',
            'sundry_creditor' => 'Sundry Creditor',
            'direct_expense' => 'Direct Expense',
            'indirect_expense' => 'Indirect Expense',
            'direct_income' => 'Direct Income',
            'indirect_income' => 'Indirect Income',
        ],
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'description' => 'Description',
            'contact' => 'Contact',
            'account' => 'Account',
            'contact_number' => 'Contact Number',
            'email' => 'Email',
            'code_prefix' => 'Prefix',
            'code_digit' => 'Digit',
            'code_suffix' => 'Suffix',
            'code_format' => 'Code Format',
            'opening_balance' => 'Opening Balance',
            'current_balance' => 'Current Balance',
            'net_balance' => 'Net Balance',
            'balance' => 'Balance :attribute',
        ],
    ],
    'ledger_type' => [
        'ledger_type' => 'Ledger Type',
        'ledger_types' => 'Ledger Types',
        'module_description' => 'Ledger Types are used to categorized ledgers based on their nature.',
        'module_example' => 'Cash, Sundry Debtor, Direct Expense are some examples of Ledger Types.',
        'default' => 'Default',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'code' => 'Code',
            'parent' => 'Parent',
            'description' => 'Description',
        ],
    ],
    'transaction' => [
        'transaction' => 'Transaction',
        'transactions' => 'Transactions',
        'module_title' => 'List all Transactions',
        'module_description' => 'Manage all Transactions',
        'detail' => 'Transaction Detail',
        'voucher' => 'Voucher',
        'payment_label' => 'Amount Paid for',
        'receipt_label' => 'Amount Received from',
        'transfer_label' => 'Amount Transferred to',
        'props' => [
            'type' => 'Type',
            'head' => 'Head',
            'status' => 'Status',
            'code_number' => 'Voucher Number',
            'code_number_short' => 'Voucher #',
            'amount' => 'Amount',
            'date' => 'Date',
            'remarks' => 'Remarks',
            'description' => 'Description',
            'instrument_number' => 'Instrument Number',
            'instrument_date' => 'Instrument Date',
            'clearing_date' => 'Clearing Date',
            'bank_detail' => 'Bank Detail',
            'reference_number' => 'Reference Number',
            'payment_rejected' => 'Payment Rejected',
            'rejected_date' => 'Date Rejected',
            'rejection_charge' => 'Rejection Charge',
            'rejection_remarks' => 'Rejection Remarks',
            'cancellation_remarks' => 'Cancellation Remarks',
        ],
        'types' => [
            'payment' => 'Payment',
            'receipt' => 'Receipt',
            'transfer' => 'Account Transfer',
        ],
        'heads' => [
        ],
        'category' => [
            'category' => 'Transaction Category',
            'categories' => 'Transaction Categories',
            'category_short' => 'Category',
            'module_title' => 'List all Transaction Categories',
            'module_description' => 'Categorize transactions for better reporting and analysis. For example: stationery, transport, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
    ],
    'payment_method' => [
        'payment_method' => 'Payment Method',
        'payment_methods' => 'Payment Methods',
        'module_title' => 'List all Payment Methods',
        'module_description' => 'Manage all Payment Methods',
        'detail' => 'Payment Method Detail',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
            'is_payment_gateway' => 'Is Payment Gateway',
            'payment_gateway_name' => 'Payment Gateway Name',
            'has_instrument_number' => 'Has Instrument Number',
            'has_instrument_date' => 'Has Instrument Date',
            'has_clearing_date' => 'Has Clearing Date',
            'has_bank_detail' => 'Has Bank Detail',
            'has_reference_number' => 'Has Reference Number',
        ],
    ],
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'info' => 'Account Information',
        'number_info' => 'Voucher Number Information',
        'module_title' => 'Manage all Account Records',
        'module_description' => 'Keep all account related information of your company & employees.',
        'props' => [
            'primary' => 'Primary',
            'name' => 'Account Name',
            'alias' => 'Alias',
            'number' => 'Account number',
            'bank_name' => 'Bank Name',
            'branch_name' => 'Branch Name',
            'branch_address' => 'Branch Address',
            'branch_code' => 'Branch Code',
        ],
    ],
    'config' => [
        'config' => 'Config',
        'info' => 'Finance Config',
        'number_variable_info' => 'You can use :attribute placeholders.',
        'props' => [
            'bank_code1' => 'Bank Code 1',
            'bank_code2' => 'Bank Code 2',
            'bank_code3' => 'Bank Code 3',
            'voucher_number_type' => 'Voucher Number Type',
            'payment_number' => 'Voucher Number',
            'payment_number_prefix' => 'Payment Voucher Number Prefix',
            'payment_number_suffix' => 'Payment Voucher Number Suffix',
            'payment_number_digit' => 'Payment Voucher Number Digit',
            'receipt_number' => 'Voucher Number',
            'receipt_number_prefix' => 'Receipt Voucher Number Prefix',
            'receipt_number_suffix' => 'Receipt Voucher Number Suffix',
            'receipt_number_digit' => 'Receipt Voucher Number Digit',
            'transfer_number' => 'Voucher Number',
            'transfer_number_prefix' => 'Transfer Voucher Number Prefix',
            'transfer_number_suffix' => 'Transfer Voucher Number Suffix',
            'transfer_number_digit' => 'Transfer Voucher Number Digit',
        ],
    ],
];
