<?php

use App\Http\Controllers\Attendance\DeviceTimesheetController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\Config\ConfigController;
use App\Http\Controllers\GuestMediaController;
use App\Http\Controllers\Site\View\PostController;
use App\Http\Controllers\Saas\InstallController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('install/pre-requisite', [InstallController::class, 'preRequisite']);
Route::post('install', [InstallController::class, 'install'])->middleware('test.mode.restriction');

// Global Routes
Route::get('ok', function () {
    return response()->json([]);
})->name('ok');

Route::get('config/pre-requisite', [ConfigController::class, 'preRequisite'])->name('config.preRequisite');
Route::get('config', [ConfigController::class, 'index'])
    ->middleware('optional.auth:sanctum')
    ->name('config');

Route::post('timesheet', [DeviceTimesheetController::class, 'store'])
    ->name('device.timesheet.store')
    ->middleware('throttle:biometric');

Route::post('qr-code-attendance', [AttendanceController::class, 'markAnomymousAttendance'])
    ->name('anonymous.attendance.mark')
    ->middleware('throttle:biometric');

Route::get('/app/site/posts', [PostController::class, 'index'])->name('site.post.index');
Route::get('/app/site/posts/{uuid}', [PostController::class, 'show'])->name('site.post.show');

Route::prefix('app/guest')->group(function () {
    Route::resource('medias', GuestMediaController::class)->only(['store', 'destroy']);
});

// Fallback route
Route::fallback(function () {
    return response()->json(['message' => trans('general.errors.api_not_found')], 404);
});
