<?php

use App\Http\Controllers\Recruitment\Job\ApplicationController;
use App\Http\Controllers\Recruitment\Job\VacancyController;
use Illuminate\Support\Facades\Route;

Route::middleware(['feature.available:feature.enable_job_application'])->group(function () {
    Route::get('app/job/vacancies/pre-requisite', [VacancyController::class, 'preRequisite'])->name('job.vacancies.preRequisite');
    Route::get('app/job/vacancies', [VacancyController::class, 'list'])->name('job.vacancies.list');
    Route::get('app/job/vacancies/{slug}', [VacancyController::class, 'detail'])->name('job.vacancies.detail');

    Route::post('app/job/vacancies/{slug}/applications', [ApplicationController::class, 'store'])->name('job.vacancies.applications');
});
