<?php

use App\Helpers\SysHelper;
use App\Models\Task\Task;
use Database\Seeders\TeamSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;

use function Pest\Laravel\seed;

uses(RefreshDatabase::class);

uses()->group('task');

beforeEach(function () {
    seed([
        TeamSeeder::class,
    ]);

    SysHelper::setTeam(1);
});

afterEach(function () {});

test('task is actionable', function () {
    $task = Task::factory()->create([
        'cancelled_at' => now()->toDateTimeString(),
    ]);

    expect($task->isActionable())->toBeFalse();

    $task = Task::factory()->create([
        'completed_at' => now()->toDateTimeString(),
    ]);

    expect($task->isActionable())->toBeFalse();
});
