<?php

namespace App\Actions\Config;

use App\Helpers\SysHelper;
use App\Http\Resources\TeamResource;
use App\Models\Team;
use App\Support\QrCodeAttendance;
use App\Support\SocialLoginProvider;
use Closure;
use Illuminate\Support\Arr;

class GetGeneralConfig
{
    use QrCodeAttendance, SocialLoginProvider;

    public function handle($config, Closure $next)
    {
        $currentVersion = SysHelper::getApp('VERSION');
        $config['auth']['social_login_providers'] = $this->getActiveProviders();
        $config['system']['url'] = config('app.url');
        $config['system']['version'] = $currentVersion;
        $config['system']['post_max_size'] = SysHelper::getPostMaxSize();
        $config['system']['mode'] = (config('app.mode') == 'test') ? 0 : 1;
        $config['system']['paginations'] = Arr::getList('per_page_lengths');

        $config['system']['currency'] = collect(Arr::getVar('currencies'))->firstWhere('name', Arr::get($config, 'system.currency'));
        $config['system']['currencies'] = collect(Arr::getVar('currencies'))->whereIn('name', explode(',', Arr::get($config, 'system.currencies')))->values();

        $config['authenticated'] = false;
        $config['is_impersonating'] = session()->has('impersonate') ? true : false;
        $config['layout']['display'] = config('config.system.enable_dark_theme') ? 'dark' : 'light';

        $mobileCompatibility = false;
        if (SysHelper::versionComparison($currentVersion, config('app.mobile_compatibility'), '>=')) {
            $mobileCompatibility = true;
        }

        $config['system']['mobile_compatibility'] = $mobileCompatibility;

        if (\Auth::check()) {
            $config['authenticated'] = true;
            $config['layout']['display'] = \Auth::user()->user_display;

            $config['system']['qr_code_attendance_enabled'] = $this->isQrCodeAttendanceEnabled();
        }

        // \App::setLocale($config['system']['locale'] ?: 'en');

        if (! empty(\Auth::user())) {
            $config['teams'] = TeamResource::collection(Team::allowedTeams()->get());

            $config['tenant'] = config('saas.validity');
            $config['tenant']['available_modules'] = config('saas.available_modules');

            if (config('saas.validity.show_expiry_alert')) {
                $expireInDays = config('saas.validity.expire_in_days');
                $expiryDate = config('saas.validity.expiry_date');

                if ($expireInDays > 2) {
                    $expireAlert = trans('saas.subscription.expire_alert_days', ['attribute' => $expireInDays]);
                } elseif ($expireInDays <= 2 && $expireInDays > 1) {
                    $expireAlert = trans('saas.subscription.expire_alert_date', ['attribute' => $expiryDate->formatted]);
                } elseif ($expireInDays == 1) {
                    $expireAlert = trans('saas.subscription.expire_alert_today', ['attribute' => trans('list.durations.today')]);
                } else {
                    $expireAlert = trans('saas.subscription.expire_alert_past', ['attribute' => $expiryDate->formatted]);
                }

                $config['tenant']['expire_alert'] = $expireAlert;
            }
        } else {
            unset($config['module']);
        }

        return $next($config);
    }
}
