<?php

namespace App\Actions\Config\Module;

class StoreLeaveConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'allow_employee_request_leave_with_exhausted_credit' => 'sometimes|boolean',
            'allow_employee_half_day_leave' => 'sometimes|boolean',
            'attendance_past_day_limit' => 'sometimes|integer|min:0|max:365',
        ], [], [
            'allow_employee_request_leave_with_exhausted_credit' => __('leave.config.props.allow_employee_request_leave_with_exhausted_credit'),
            'allow_employee_half_day_leave' => __('leave.config.props.allow_employee_half_day_leave'),
            'attendance_past_day_limit' => __('leave.config.props.attendance_past_day_limit'),
        ]);

        return $input;
    }
}
