<?php

namespace App\Actions\Config;

class StoreAuthConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'session_lifetime' => 'sometimes|required|integer|min:1|max:99999999',
            'login_throttle_max_attempts' => 'sometimes|required|integer|min:2|max:10',
            'login_throttle_lock_timeout' => 'sometimes|required|integer|min:1|max:300',
            'enable_reset_password' => 'sometimes|boolean',
            'reset_password_token_lifetime' => 'required_if:enable_reset_password,true|integer|min:5|max:300',
            'enable_registration' => 'sometimes|boolean',
            'enable_registration_terms' => 'sometimes|boolean',
            'enable_email_verification' => 'sometimes|boolean',
            'enable_account_approval' => 'sometimes|boolean',
            'enable_two_factor_security' => 'sometimes|boolean',
            'two_factor_security_lifetime' => 'required_if:enable_two_factor_security,true|integer|min:2|max:20',
            'enable_otp_login' => 'sometimes|boolean',
            'otp_login_lifetime' => 'required_if:enable_otp_login,true|integer|min:5|max:300',
            'enable_email_otp_login' => 'sometimes|boolean',
            'enable_sms_otp_login' => 'sometimes|boolean',
            'enable_screen_lock' => 'sometimes|boolean',
            'screen_lock_timeout' => 'required_if:enable_screen_lock,true|integer|min:1|max:60',
            'enable_oauth_login' => 'sometimes|boolean',
            'enable_google_oauth_login' => 'sometimes|boolean',
            'google_client_id' => 'required_if:enable_google_oauth_login,true',
            'google_client_secret' => 'required_if:enable_google_oauth_login,true',
            'google_callback_url' => 'nullable|required_if:enable_google_oauth_login,true|url',
            'enable_facebook_oauth_login' => 'sometimes|boolean',
            'facebook_client_id' => 'required_if:enable_facebook_oauth_login,true',
            'facebook_client_secret' => 'required_if:enable_facebook_oauth_login,true',
            'facebook_callback_url' => 'nullable|required_if:enable_facebook_oauth_login,true|url',
            'enable_twitter_oauth_login' => 'sometimes|boolean',
            'twitter_client_id' => 'required_if:enable_twitter_oauth_login,true',
            'twitter_client_secret' => 'required_if:enable_twitter_oauth_login,true',
            'twitter_callback_url' => 'nullable|required_if:enable_twitter_oauth_login,true|url',
            'enable_github_oauth_login' => 'sometimes|boolean',
            'github_client_id' => 'required_if:enable_github_oauth_login,true',
            'github_client_secret' => 'required_if:enable_github_oauth_login,true',
            'github_callback_url' => 'nullable|required_if:enable_github_oauth_login,true|url',
            'enable_microsoft_oauth_login' => 'sometimes|boolean',
            'microsoft_client_id' => 'required_if:enable_microsoft_oauth_login,true',
            'microsoft_client_secret' => 'required_if:enable_microsoft_oauth_login,true',
            'microsoft_callback_url' => 'nullable|required_if:enable_microsoft_oauth_login,true|url',
        ], [
            'google_client_id.required_if' => __('validation.required'),
            'google_client_secret.required_if' => __('validation.required'),
            'google_callback_url.required_if' => __('validation.required'),
            'facebook_client_id.required_if' => __('validation.required'),
            'facebook_client_secret.required_if' => __('validation.required'),
            'facebook_callback_url.required_if' => __('validation.required'),
            'twitter_client_id.required_if' => __('validation.required'),
            'twitter_client_secret.required_if' => __('validation.required'),
            'twitter_callback_url.required_if' => __('validation.required'),
            'github_client_id.required_if' => __('validation.required'),
            'github_client_secret.required_if' => __('validation.required'),
            'github_callback_url.required_if' => __('validation.required'),
            'microsoft_client_id.required_if' => __('validation.required'),
            'microsoft_client_secret.required_if' => __('validation.required'),
            'microsoft_callback_url.required_if' => __('validation.required'),
        ], [
            'session_lifetime' => __('config.auth.props.session_lifetime'),
            'login_throttle_max_attempts' => __('config.auth.props.login_throttle_max_attempts'),
            'login_throttle_lock_timeout' => __('config.auth.props.login_throttle_lock_timeout'),
            'enable_reset_password' => __('config.auth.props.enable_reset_password'),
            'reset_password_token_lifetime' => __('config.auth.props.reset_password_token_lifetime'),
            'enable_registration' => __('config.auth.props.enable_registration'),
            'enable_registration_terms' => __('config.auth.props.enable_registration_terms'),
            'enable_email_verification' => __('config.auth.props.enable_email_verification'),
            'enable_account_approval' => __('config.auth.props.enable_account_approval'),
            'enable_two_factor_security' => __('config.auth.props.enable_two_factor_security'),
            'two_factor_security_lifetime' => __('config.auth.props.two_factor_security_lifetime'),
            'enable_otp_login' => __('config.auth.props.enable_otp_login'),
            'otp_login_lifetime' => __('config.auth.props.otp_login_lifetime'),
            'enable_email_otp_login' => __('config.auth.props.enable_email_otp_login'),
            'enable_sms_otp_login' => __('config.auth.props.enable_sms_otp_login'),
            'enable_screen_lock' => __('config.auth.props.enable_screen_lock'),
            'screen_lock_timeout' => __('config.auth.props.screen_lock_timeout'),
            'enable_oauth_login' => __('config.auth.props.enable_oauth_login'),
            'enable_google_oauth_login' => __('config.auth.props.enable_oauth', ['attribute' => 'Google']),
            'google_client_id' => __('config.auth.props.client_id', ['attribute' => 'Google']),
            'google_client_secret' => __('config.auth.props.client_secret', ['attribute' => 'Google']),
            'google_callback_url' => __('config.auth.props.callback_url', ['attribute' => 'Google']),
            'enable_facebook_oauth_login' => __('config.auth.props.enable_oauth', ['attribute' => 'Facebook']),
            'facebook_client_id' => __('config.auth.props.client_id', ['attribute' => 'Facebook']),
            'facebook_client_secret' => __('config.auth.props.client_secret', ['attribute' => 'Facebook']),
            'facebook_callback_url' => __('config.auth.props.callback_url', ['attribute' => 'Facebook']),
            'enable_twitter_oauth_login' => __('config.auth.props.enable_oauth', ['attribute' => 'Twitter']),
            'twitter_client_id' => __('config.auth.props.client_id', ['attribute' => 'Twitter']),
            'twitter_client_secret' => __('config.auth.props.client_secret', ['attribute' => 'Twitter']),
            'twitter_callback_url' => __('config.auth.props.callback_url', ['attribute' => 'Twitter']),
            'enable_github_oauth_login' => __('config.auth.props.enable_oauth', ['attribute' => 'Github']),
            'github_client_id' => __('config.auth.props.client_id', ['attribute' => 'Github']),
            'github_client_secret' => __('config.auth.props.client_secret', ['attribute' => 'Github']),
            'github_callback_url' => __('config.auth.props.callback_url', ['attribute' => 'Github']),
            'enable_microsoft_oauth_login' => __('config.auth.props.enable_oauth', ['attribute' => 'Microsoft']),
            'microsoft_client_id' => __('config.auth.props.client_id', ['attribute' => 'Microsoft']),
            'microsoft_client_secret' => __('config.auth.props.client_secret', ['attribute' => 'Microsoft']),
            'microsoft_callback_url' => __('config.auth.props.callback_url', ['attribute' => 'Microsoft']),
        ]);

        return $input;
    }
}
