<?php

namespace App\Actions\Saas;

use App\Models\Config\Config;
use App\Models\Saas\Tenant;
use Closure;
use Illuminate\Support\Arr;

class CheckLandlordConnection
{
    public function handle(Tenant $tenant, Closure $next)
    {
        try {
            \DB::connection('landlord')->getPdo();
        } catch (\Exception $e) {
            abort('398', trans('setup.errors.db_connection_fail'));
        }

        $config = Config::whereIn('name', [
            'tenant', 'subscription', 'mail', 'system', 'assets', 'general', 'server',
        ])->pluck('value', 'name')->all();

        $url = Arr::get(parse_url(config('app.url')), 'host');
        $icon = Arr::get($config, 'assets.icon', '/images/icon.png');
        $logo = Arr::get($config, 'assets.logo', '/images/logo.png');

        config([
            'saas.landlord' => $config,
            'saas.url' => $url,
            'saas.icon' => 'https://'.$url.$icon,
            'saas.logo' => 'https://'.$url.$logo,
        ]);

        return $next($tenant);
    }
}
