<?php

namespace App\Actions\Saas;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Http;
use Illuminate\Validation\ValidationException;

class Cpanel
{
    public function execute(string $database): void
    {
        $response = $this->performAction('list_databases');

        $existingDatabase = Arr::first(Arr::get($response, 'data'), function ($value) use ($database) {
            return $value['database'] === $database;
        });

        // logger('Existing Database: ' . Arr::get($existingDatabase, 'database'));

        if (empty($existingDatabase)) {
            // logger('Creating Database');
            $this->performAction('create_database?name='.$database);
            // logger('Granting Priviledges');
            $this->grantPrivileges($database);
        } else {
            $databaseUsers = Arr::get($existingDatabase, 'users');

            // logger('Existing Database Users');
            // logger($databaseUsers);

            if (! in_array(config('database.connections.landlord.username'), $databaseUsers)) {
                // logger('Granting Priviledges when user does not exist');
                $this->grantPrivileges($database);
            }
        }
    }

    private function performAction(string $action): array
    {
        $response = Http::withHeaders([
            'Authorization' => 'cpanel '.config('saas.landlord.server.cpanel_username').':'.config('saas.landlord.server.cpanel_api_token'),
        ])->get('https://'.config('saas.landlord.server.cpanel_hostname').':'.config('saas.landlord.server.cpanel_port').'/execute/Mysql/'.$action);

        if (empty($response->json())) {
            throw ValidationException::withMessages(['message' => $response->body()]);
        }

        $response = $response->json();

        if (! Arr::get($response, 'status')) {
            throw ValidationException::withMessages(['message' => Arr::first(Arr::get($response, 'errors'))]);
        }

        return $response;
    }

    public function createUser(string $database): void
    {
        //
    }

    public function grantPrivileges(string $database): void
    {
        $this->performAction('set_privileges_on_database?user='.config('database.connections.landlord.username').'&database='.$database.'&privileges=ALL%20PRIVILEGES');
    }
}
