<?php

namespace App\Actions\Saas;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class CreateDatabase
{
    public function getDatabasePrefix()
    {
        return config('saas.landlord.server.db_prefix').'hrm_';
    }

    public function handle(Request $request, Closure $next)
    {
        if (! $request->database) {
            $database = $this->getDatabasePrefix().$request->tenant_id;
            $request->merge(['database' => $database]);

            if (config('saas.landlord.server.platform') == 'cpanel') {
                $this->createCpanelDatabase($database);
            } else {
                $this->createLocalDatabase($database);
            }
        }

        (new SwitchDatabase)->execute($request->database);

        return $next($request);
    }

    private function createCpanelDatabase(string $database): void
    {
        (new Cpanel)->execute($database);
    }

    private function createLocalDatabase(string $database): void
    {
        try {
            \DB::statement('CREATE DATABASE IF NOT EXISTS '.$database);
        } catch (\Exception $e) {
            throw ValidationException::withMessages(['message' => trans('saas.errors.db_connection_error')]);
        }
    }
}
