<?php

namespace App\Actions\Saas;

use App\Enums\Saas\TenantStatus;
use App\Models\Saas\Tenant;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class FindInstallableTenant
{
    public function handle(Request $request, Closure $next)
    {
        $tenant = Tenant::query()
            ->whereId(config('saas.tenant.id'))
            ->whereEmail($request->email)
            ->where('meta->activation_token', $request->activation_token)
            ->whereStatus(TenantStatus::PENDING->value)
            ->first();

        if (! $tenant) {
            throw ValidationException::withMessages(['message' => trans('saas.errors.tenant_verification_fail')]);
        }

        $request->merge([
            'database' => $tenant->database,
            'tenant_id' => $tenant->id,
        ]);

        return $next($request);
    }
}
