<?php

namespace App\Actions\Saas;

use App\Models\Config\Config;
use Closure;
use Illuminate\Http\Request;

class SetDefaultConfig
{
    public function handle(Request $request, Closure $next)
    {
        $config = Config::firstOrCreate([
            'name' => 'general',
        ]);

        $config->value = [
            'app_name' => config('saas.landlord.tenant.default_app_name'),
        ];
        $config->save();

        $config = Config::firstOrCreate([
            'name' => 'mail',
        ]);

        $config->value = [
            'from_name' => $request->name,
            'from_address' => $request->email,
        ];
        $config->save();

        $config = Config::firstOrCreate([
            'name' => 'system',
        ]);

        $defaultLocale = config('saas.landlord.tenant.default_locale', 'en');

        if (! \File::exists(base_path('lang/'.$defaultLocale))) {
            $defaultLocale = 'en';
        }

        $config->value = [
            'locale' => $defaultLocale,
            'currency' => config('saas.landlord.tenant.default_currency'),
            'currencies' => config('saas.landlord.tenant.default_currency'),
            'timezone' => config('saas.landlord.tenant.default_timezone'),
            'footer_credit' => config('saas.landlord.tenant.default_footer_credit'),
            'show_setup_wizard' => true,
        ];

        $config->save();

        return $next($request);
    }
}
