<?php

namespace App\Actions\Saas\Subscription;

use App\Enums\Saas\PlanFrequency;
use App\Enums\Saas\SubscriptionType;
use App\Models\Saas\Plan;
use App\Models\Saas\Tenant;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Illuminate\Validation\ValidationException;

class CalculateDowngradeSubscription
{
    public function execute(Request $request, Tenant $tenant, Plan $newPlan, Collection $existingSubscriptions)
    {
        // Check if limits are permissible

        $action = SubscriptionType::DOWNGRADE->value;

        $currency = $request->currency;
        $frequency = $request->frequency;

        if ($currency != $tenant->getMeta('currency')) {
            throw ValidationException::withMessages(['message' => trans('saas.errors.change_currency')]);
        }

        $amount = $newPlan->getPrice($currency, $frequency);

        $startDate = $tenant->expiry_date->value;

        $endDate = Carbon::parse($startDate)->addMonths(PlanFrequency::getMonth($frequency))->toDateString();

        $tax = (new GetTax)->execute(plan: $newPlan, amount: $amount);
        $taxAmount = Arr::get($tax, 'taxAmount', 0);
        $taxAddition = Arr::get($tax, 'taxAddition', 0);
        $taxLabel = Arr::get($tax, 'taxLabel');

        $total = $amount + $taxAmount;

        return compact('action', 'amount', 'startDate', 'endDate', 'taxAmount', 'taxLabel', 'total');
    }
}
