<?php

namespace App\Actions\Saas\Subscription;

use App\Helpers\SysHelper;
use App\Models\Saas\Plan;
use Illuminate\Support\Arr;

class GetTax
{
    public function execute(Plan $plan, float $amount): array
    {
        if ($plan->getFeature('is_free')) {
            return [];
        }

        if (! Arr::get($plan->tax, 'is_enabled')) {
            return [];
        }

        $taxLabel = Arr::get($plan->tax, 'label');
        $taxRate = Arr::get($plan->tax, 'rate', 0);
        $taxType = Arr::get($plan->tax, 'is_exclusive') ? 'exclusive' : 'inclusive';

        $taxLabel = $taxLabel.' '.$taxRate.'% ('.trans('saas.subscription.props.tax_type_'.$taxType).')';

        $taxAmount = 0;
        $taxAddition = 0;
        if ($taxType == 'inclusive') {
            $taxAmount = SysHelper::formatAmount($amount - ($amount / (1 + ($taxRate / 100))));
        } else {
            $taxAmount = SysHelper::formatAmount($amount * ($taxRate / 100));
            $taxAddition = $taxAmount;
        }

        return compact('taxAmount', 'taxAddition', 'taxLabel');
    }
}
