<?php

namespace App\Actions\Saas\Subscription;

use App\Enums\Saas\SubscriptionType;
use App\Models\Saas\Subscription;
use App\Models\Saas\Tenant;
use Closure;
use Illuminate\Support\Arr;

class UpdateTenant
{
    public function handle(Subscription $subscription, Closure $next)
    {
        $tenant = Tenant::find(config('saas.tenant.id'));

        $tenant->address = Arr::get($subscription->billing_address, 'address', []);

        if ($subscription->start_date->value <= today()->toDateString()) {
            $tenant->is_trial = 0;
            $tenant->plan_id = $subscription->plan_id;
            $tenant->expiry_date = $subscription->expiry_date->value;
        }

        if (in_array($subscription->action, [SubscriptionType::NEW->value, SubscriptionType::RENEW->value, SubscriptionType::CONTINUE->value, SubscriptionType::DOWNGRADE->value])) {
            $tenant->expiry_date = $subscription->expiry_date->value;
        }

        $meta = $tenant->meta;
        $meta['frequency'] = $subscription->frequency;
        $meta['currency'] = $subscription->currency;
        $tenant->meta = $meta;

        $tenant->save();

        return $next($subscription);
    }
}
