<?php

namespace App\Actions\Saas;

class SwitchDatabase
{
    public function execute($database = 'landlord')
    {
        if ($database == 'landlord') {
            $this->toLandlord();
        } else {
            config([
                'database.connections.tenant.database' => $database,
            ]);

            $this->toTenant();
        }
    }

    private function toLandlord()
    {
        \DB::disconnect('tenant');
        \DB::setDefaultConnection('landlord');

        config([
            'telescope.storage.database.connection' => 'landlord',
        ]);
    }

    private function toTenant()
    {
        config([
            'telescope.storage.database.connection' => 'tenant',
        ]);

        try {
            \DB::connection('tenant')->getPdo();
        } catch (\Exception $e) {
            abort('398', trans('saas.errors.db_connection_error'));
        }

        \DB::disconnect('landlord');
        \DB::setDefaultConnection('tenant');
    }
}
