<?php

namespace App\Concerns;

use App\Enums\Saas\TenantStatus;
use App\Models\Saas\Tenant;
use Illuminate\Database\Eloquent\Collection;

trait GetTenantsForCommand
{
    public static function bootHasCodeNumber() {}

    public function getTenants(array $ids = []): Collection
    {
        $force = $this->option('force');

        if (! count($ids) && ! $force) {
            if (! $this->confirm('Are you sure running this command for all tenants?')) {
                $this->error('Permission denied.');
                exit();
            }
        }

        $tenants = Tenant::query()
            ->when($ids, function ($q, $ids) {
                $q->whereIn('id', $ids);
            })
            ->whereNotNull('database')
            ->whereNotIn('status', [TenantStatus::PENDING->value])
            ->get();

        $this->info('Tenants found: '.$tenants->count());
        $this->newLine();

        if ($force) {
            return $tenants;
        }

        if (! $this->confirm('Are you sure wish to proceed?')) {
            $this->error('Permission denied.');
            exit();
        }

        return $tenants;
    }
}
