<?php

namespace App\Concerns;

trait ModelRelation
{
    /**
     * Get all relations
     *
     * @return array
     */
    public function relations()
    {
        return [
            'Team' => 'App\Models\Team',
            'User' => 'App\Models\User',
            'Tag' => 'App\Models\Tag',
            'Comment' => 'App\Models\Comment',
            'Config' => 'App\Models\Config\Config',
            'Todo' => 'App\Models\Utility\Todo',
            'Role' => 'App\Models\Config\Role',
            'Option' => 'App\Models\Option',
            'Template' => 'App\Models\Config\Template',
            'Media' => 'App\Models\Media',
            'Post' => 'App\Models\Post\Post',
            'Account' => 'App\Models\Account',
            'Qualification' => 'App\Models\Qualification',
            'Document' => 'App\Models\Document',
            'Experience' => 'App\Models\Experience',
            'Department' => 'App\Models\Company\Department',
            'Designation' => 'App\Models\Company\Designation',
            'Branch' => 'App\Models\Company\Branch',
            'Employee' => 'App\Models\Employee\Employee',
            'EmployeeRecord' => 'App\Models\Employee\Record',
            'LeaveType' => 'App\Models\Leave\Type',
            'LeaveAllocation' => 'App\Models\Leave\Allocation',
            'LeaveRequest' => 'App\Models\Leave\Request',
            'AttendanceType' => 'App\Models\Attendance\Type',
            'Attendance' => 'App\Models\Attendance\Attendance',
            'WorkShift' => 'App\Models\Attendance\WorkShift',
            'Timesheet' => 'App\Models\Attendance\Timesheet',
            'LedgerType' => 'App\Models\Finance\LedgerType',
            'Ledger' => 'App\Models\Finance\Ledger',
            'Transaction' => 'App\Models\Finance\Transaction',
            'Payroll' => 'App\Models\Payroll\Payroll',
            'SalaryTemplate' => 'App\Models\Payroll\SalaryTemplate',
            'SalaryStructure' => 'App\Models\Payroll\SalaryStructure',
            'Communication' => 'App\Models\Communication\Communication',
            'Announcement' => 'App\Models\Communication\Announcement',
            'Form' => 'App\Models\Form\Form',
            'FormSubmission' => 'App\Models\Form\Submission',
            'JobVacancy' => 'App\Models\Recruitment\Vacancy',
            'JobApplication' => 'App\Models\Recruitment\Application',
            'Task' => 'App\Models\Task\Task',
            'TaskChecklist' => 'App\Models\Task\Checklist',
        ];
    }
}
