<?php

namespace App\Concerns\Saas;

use App\Models\Saas\Subscription;
use Illuminate\Validation\ValidationException;

trait HasPaymentGateway
{
    public function validateCurrency(Subscription $subscription, array $supportedCurrencies, array $unsupportedCurrencies): void
    {
        if ($supportedCurrencies && ! in_array($subscription->currency, $supportedCurrencies)) {
            throw ValidationException::withMessages(['message' => trans('finance.unsupported_currency', ['currency' => $subscription->currency])]);
        }

        if ($unsupportedCurrencies && in_array($subscription->currency, $unsupportedCurrencies)) {
            throw ValidationException::withMessages(['message' => trans('finance.unsupported_currency', ['currency' => $subscription->currency])]);
        }
    }
}
