<?php

namespace App\Console\Commands;

use App\Actions\Saas\SwitchDatabase;
use App\Concerns\GetTenantsForCommand;
use Illuminate\Console\Command;

class TenantMigrateRollback extends Command
{
    use GetTenantsForCommand;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tenant:migrate:rollback {tenant?* : ID of Tenants} {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Tenant migrate command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $tenantIds = $this->argument('tenant');

        $tenants = $this->getTenants($tenantIds);

        $bar = $this->output->createProgressBar(count($tenants));
        $bar->start();

        foreach ($tenants as $tenant) {
            $this->newLine();
            $this->info('Migration Rolling tenant: '.$tenant->id);

            (new SwitchDatabase)->execute($tenant->database);

            \Artisan::call('migrate:rollback', ['--force' => true]);

            $this->info('Migration Rolling complete tenant: '.$tenant->id);

            $bar->advance();
            $this->newLine();

            (new SwitchDatabase)->execute();
        }

        $bar->finish();
    }
}
