<?php

namespace App\Enums\Saas;

use App\Concerns\HasEnum;

enum PlanFrequency: string
{
    use HasEnum;

    case MONTHLY = 'monthly';
    case ANNUALLY = 'annually';

    public static function translation(): string
    {
        return 'saas.plan.frequencies.';
    }

    public static function getMonth(string $value = ''): int
    {
        $frequency = self::tryFrom($value);

        if (! $frequency) {
            return 0;
        }

        if ($frequency->value == 'monthly') {
            return 1;
        } elseif ($frequency->value == 'annually') {
            return 12;
        } else {
            return 0;
        }
    }
}
