<?php

namespace App\Enums\Saas;

use App\Concerns\HasEnum;
use App\Contracts\HasColor;

enum TenantStatus: string implements HasColor
{
    use HasEnum;

    case PENDING = 'pending';
    case RUNNING = 'running';
    case EXPIRED = 'expired';
    case SUSPENDED = 'suspended';
    case TERMINATED = 'terminated';

    public static function translation(): string
    {
        return 'saas.tenant.statuses.';
    }

    public function color(): string
    {
        return match ($this) {
            self::PENDING => 'info',
            self::RUNNING => 'success',
            self::EXPIRED => 'danger',
            self::SUSPENDED => 'warning',
            self::TERMINATED => 'danger',
        };
    }
}
