<?php

namespace App\Http\Controllers\Saas;

use App\Actions\Saas\Install;
use App\Helpers\SysHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Saas\InstallRequest;

class InstallController extends Controller
{
    public function preRequisite()
    {
        return [
            'app' => [
                'title' => config('app.name'),
                'version' => SysHelper::getApp('VERSION'),
            ],
        ];
    }

    public function install(InstallRequest $request, Install $install)
    {
        $install->execute($request);

        return response()->success(['message' => trans('setup.install.completed')]);
    }
}
