<?php

namespace App\Http\Controllers\Saas;

use App\Http\Controllers\Controller;
use App\Models\Saas\Subscription;

class SubscriptionActionController extends Controller
{
    public function print($subscription)
    {
        $subscription = Subscription::query()
            ->with('plan')
            ->whereUuid($subscription)
            ->firstOrFail();

        if (! $subscription->status || $subscription->tenant_id != config('saas.tenant.id')) {
            abort(404);
        }

        return view('print.subscription', compact('subscription'));
    }
}
